/*  Copyright 2025 Leuze electronic GmbH + Co. KG
 *
 *  Licensed under the Apache License, Version 2.0
 */

#include "leuze_rod_driver/rod_node.h"

/*
 * @brief ROD driver main rutine
 */
int main(int argc, char **argv)
{
    rclcpp::init(argc, argv);

    std::string ip_addr     = ROD_DEFAULT_IP_ADDRESS;
    std::string port_num    = ROD_DEFAULT_PORT;
    std::string topic_id    = ROD_DEFAULT_TOPIC_ID;
    std::string frame_id    = ROD_DEFAULT_FRAME_ID;

    if (argc <= 4)
    {
        
    }
    else
    {
        ip_addr     = argv[1];
        port_num    = argv[2];
        topic_id    = argv[3];
        frame_id    = argv[4];
    }

    auto rod_node = std::make_shared<leuze_rod_ros2_drivers::RodNode>(ip_addr, port_num, topic_id, frame_id);
    
    rclcpp::spin(rod_node);
    rclcpp::shutdown();

    return 0;
}
