# Package: leuze_description

This package contains visualisation launch script and the 3D models for a ROS 2 driver for the ROD 308 and ROD 508 laser scanners. The driver is released under the [Apache license, Version 2.0](https://www.apache.org/licenses/LICENSE-2.0). Please read the file LICENSE before using or modifying the driver.

Refer to the main README.md file for complete instructions on installing, launching, and using the ROS 2 driver for ROD laser scanners.

## Visualization execution

You can launch the vizualitation using the provided script. Open a terminal in your ROS 2 workspace directory and run the following commands to build, source, and execute the driver.

```
colcon build
source install/setup.bash
ros2 launch leuze_description view_rod300_500.launch.py
```

This opens RViz 2 with a preloaded ROD x08 scanner model. Two fixed frames are available:

*   `scanner_laser`         - laser beams positioned at height 0
*   `scanner_mount_link`    - laser beams positioned at a realistic mounting height
                            (e.g., floor-mounted).

To see the scan data in the RViz2 window it as necessary to execute also the driver for the ROD x08 Laser scanner in a separated terminal.

<div align="center">
    <img src="../leuze_description/doc/vizualisation.PNG" alt="ROS2 driver for ROD x08 Laser scanner" >
</div>

---

© 2025 **Leuze electronic GmbH + Co. KG**.     
Visit [www.leuze.com](https://www.leuze.com) | Contact: [info@leuze.com](mailto:info@leuze.com)  