# Package: leuze_bringup

This package contains a launch file for a ROS 2 driver for the ROD 308 and ROD 508 laser scanners. The driver is released under the [Apache license, Version 2.0](https://www.apache.org/licenses/LICENSE-2.0). Please read the file LICENSE before using or modifying the driver.

Refer to the main README.md file for complete instructions on installing, launching, and using the ROS 2 driver for ROD laser scanners.

## Driver Execution

You can launch the driver using the provided script. Open a terminal in your ROS 2 workspace directory and run the following commands to build, source, and execute the driver.

```
colcon build
source install/setup.bash
ros2 launch leuze_bringup leuze_bringup_rod.launch.py 
```

This launches the driver with the following default settings:

*   IP Address: `192.168.60.101`
*   Port:       `3050`
*   Topic ID:   `scan1`
*   Frame ID:   `scanner_laser`

### Parameters

If the default settings don't apply, only the following parameters must be specified. The driver will automatically retrieve all other settings from the scanner:

*   `ip_addr`:  Scanner IP address
*   `port_num`: Port number
*   `topic_id`: ROS 2 topic name to publish scan data
*   `frame_id`: Frame ID associated with the scan data

Example:
```
ros2 launch leuze_bringup leuze_bringup_rod.launch.py ip_addr:=192.168.2.38 port_num:=1234 topic_id:=scan1 frame_id:=scanner_laser
```

---

© 2025 **Leuze electronic GmbH + Co. KG**.     
Visit [www.leuze.com](https://www.leuze.com) | Contact: [info@leuze.com](mailto:info@leuze.com)  