/*  Copyright 2025 Leuze electronic GmbH + Co. KG
 *
 *  Licensed under the Apache License, Version 2.0
 */

#include <ros/ros.h>
#include <std_msgs/Time.h>

#include "leuze_rod_driver/rod_driver.h"
#include "leuze_rod_driver/rod_node.h"

int main(int argc, char** argv)
{
    ros::init(argc, argv, "leuze_rod_driver");
    ros::NodeHandle nh("~");  // Private node handle to access private parameters

    std::string ip_addr     = ROD_DEFAULT_IP_ADDRESS;
    std::string port_num    = std::to_string(ROD_DEFAULT_PORT);
    std::string topic_id    = ROD_DEFAULT_TOPIC_ID;   
    std::string frame_id    = ROD_DEFAULT_FRAME_ID;

    ROS_INFO("Given %d arguments", argc);

    if (5 == argc) // argc counts program name + arguments
    {
        ROS_INFO("Parsing parameters from given arguments...");

        ip_addr     = argv[1];
        port_num    = argv[2];
        topic_id    = argv[3];
        frame_id    = argv[4];
    }
    else
    {
        ROS_INFO("Reading parameters from parameter server...");

        std::int32_t i_port_num;

        nh.param<std::string>("ip_addr", ip_addr, ROD_DEFAULT_IP_ADDRESS);
        nh.param<std::int32_t>("port_num", i_port_num, ROD_DEFAULT_PORT);
        nh.param<std::string>("topic_id", topic_id, ROD_DEFAULT_TOPIC_ID);
        nh.param<std::string>("frame_id", frame_id, ROD_DEFAULT_FRAME_ID);

        port_num = std::to_string(i_port_num);
    }  

    leuze_rod_ros1_drivers::RodNode rod_node(ip_addr, port_num, topic_id, frame_id);
    rod_node.spin();

    return 0;
}
