# Package: leuze_rod_driver  

This package contains the complete source code for a ROS 1 driver for the ROD 308 and ROD 508 laser scanners. The driver is released under the [Apache license, Version 2.0](https://www.apache.org/licenses/LICENSE-2.0). Please read the LICENSE file before using or modifying the driver.

Refer to the main `README.md` file for complete instructions on installing, launching, and using the ROS 1 driver for ROD laser scanners.

## Class diagram

The source code is divided into multiple classes based on functionality. See the class diagram and the descriptions below to better understand the internal structure of the ROS 1 driver for Leuze ROD x08 laser scanners.

<div align="center">
    </br>
    <img src="../leuze_description/doc/class_diagram.PNG" alt="leuze_rod_driver Class Diagram" width="600">
</div>

*   Class `RodNode`:

    *   Inherits from class rclpp::Node
    *   Publishes the following messages:
        *   `LaserScan`             - standard ROS 1 message for laser scan data
        *   `StatusProfileMsgRod`   - custom Leuze message containing status and configuration data of the connected ROD x08 laser scanner

*   Class `EthCommIfc`:

    *   Pure abstract class
    *   Defines an interface for both real and simulated ROD x08 laser scanner communication

*   Class `EthCommRod`:

    *   Implements  `EthCommIfc`
    *   ensures communication with a real ROD x08 Laser scanner:
        *   Uses  `EthCommTCP` for TCP communication
        *   Uses  `EthCommUDP` for UDP communication

*   Classs `EthCommSim`:

    *   Implements  `EthCommIfc`
    *   Simulates communication with a ROD x08 laser scanner

*   Class `EthCommTCP`:

    *   Inherits from `ScanDataParser`
    *   Opens a TCP socket for communication with the ROD x08 laser scanner
    *   Handles:
        *   Configuration and status data via the TCP command interface
        *   Measured distance and intensity data (MDI packets)

*   Class `EthCommUDP`

    *   Inherits from `ScanDataParser`
    *   Opens a UDP socket for communication
    *   Captures measured distance and intensity data (MDI packets)

*   Class `ScanDataParser`

    * Captures packets into a ring buffer
    * Parses scan data from the buffer

## Driver execution

The `leuze_rod_driver` can be executed directly without a launch file from the `leuze_bringup` package. Use the command below to run it with default settings (IP address, port, etc.):

Note: Before running, ensure the driver is built and sourced.
The `leuze_msgs` package is required as it contains the status message published by the driver.

```
catkin_make
source devel/setup.bash
rosrun leuze_rod_driver leuze_rod_driver
```
You can also provide specific parameters directly:

```
rosrun leuze_rod_driver leuze_rod_driver <IP_address> <port_num> <topic_id> <frame_id>
```
Example:

```
rosrun leuze_rod_driver leuze_rod_driver 192.168.2.38 3050 scan1 scanner_laser
```

---

© 2025 **Leuze electronic GmbH + Co. KG**.     
Visit [www.leuze.com](https://www.leuze.com) | Contact: [info@leuze.com](mailto:info@leuze.com)  